﻿var scheduleEditor = {
    context: $(".v-scheduleEditor"),
    container: null,
    showFileNameOption: function (value) {
        var optionsSelect = $(".h-selectFileNameSource");
        var section = optionsSelect.closest(".distributeContent");

        if (value == "" || !value) {
            $('.v-optionExample', section).text("");
        }
        else {
            var fpath = value.replace(/\\/g, '/');
            var idxExtension = value.lastIndexOf('.');
            var fname = value.substring(value.lastIndexOf('/') + 1);
            var extension = "";

            if (idxExtension > 0) {
                fname = value.substring(value.lastIndexOf('/') + 1, idxExtension);
                extension = value.substring(idxExtension);
            }

            if (optionsSelect.val() == "CurrentDate") {
                $('.v-optionExample', section).text(fname + "_YYYY_MM_DD" + extension);
            }
            else if (optionsSelect.val() == "HighestNumber") {
                var sl = section.attr("data-label-starts-at");
                $('.v-optionExample', section).text(sl + ": " + fname + "_1" + extension);
            }
            else {
                $('.v-optionExample', section).text("");
            }
        }
    },

    getSummary: function () {
        var sd = $("#StartDate").val();
        var ed = $("#HasNoEndDate").is(":checked") ? null : $("#EndDate").val();
        var fre = $("#Frequence").val();
        var int = $("#Interval").val();
        var type = $("#ForType").val();
        var mo = $("#IncMonday").is(":checked");
        var tu = $("#IncTuesday").is(":checked");
        var wed = $("#IncWednesday").is(":checked");
        var th = $("#IncThursday").is(":checked");
        var fr = $("#IncFriday").is(":checked");
        var sa = $("#IncSaturday").is(":checked");
        var su = $("#IncSunday").is(":checked");

        var hi = $("#HourInterval");
        var hours = $("#HourInterval").val();
        var repeat = $("#HasFrequence:checked").val() == "true";

        if (hi.is(":hidden") || $("#HasNoHourlyInterval").is(":checked") || isNaN(hours)) {
            hours = 0;
        }

        if (!int) {
            int = 0;
        }

        a4.callServerMethod(a4.getAction("GetScheduleSummary", "Shared"), { startDate: sd, frequence: fre, repeat: repeat, type: type, interval: int, endDate: ed, hours: hours, mo: mo, tu: tu, wed: wed, th: th, fr: fr, sa: sa, su: su },
        function (result) {
            $(".v-summaryContent", scheduleEditor.context).text(result.summary);
            $("#Summary", scheduleEditor.context).val(result.summary);
            scheduleEditor.refreshTimeSummary();
        });
    },

    refreshTimeSummary: function () {
        var sd = $("#StartDate").val();
        var idx = (sd) ? sd.indexOf(' ') : 0;
        var time = sd.substring(idx + 1);

        $("#labelHourly").text($("#labelHourly").attr("data-text").replace("{0}", time));
        $("#labelNoHourly span").text($("#labelNoHourly").attr("data-text").replace("{0}", time));
    }
}

$(document).ready(function () {
    if (scheduleEditor.context.length > 0) {
        $(".v-ftpContent").toggleClass("hidden", $("#Schedule_FileSource").is(':checked'));
        $(".v-fileHelper").toggleClass("hidden", $("#Schedule_FileSource").is(':checked') == false);
        $(".h-datetimepicker", scheduleEditor.context).datetimepicker();
        $("#ui-datepicker-div:visible").hide();
        scheduleEditor.refreshTimeSummary();
        scheduleEditor.getSummary();

        var endDate = $(".h-datepicker", scheduleEditor.context);
        endDate.datepicker({ minDate: new Date() });
        var endDateValue = endDate.val();

        if (endDateValue.indexOf(':') != -1) {
            endDate.val(endDateValue.substring(0, endDateValue.indexOf(' ')));
        }

        scheduleEditor.context.on("change", ".scheduleContent select:visible,input:visible", function () {
            scheduleEditor.getSummary();
        });

        scheduleEditor.context.on("change", "input[type='radio'][name='Schedule.FileSource']", function () {
            var parent = $(this).closest(".content");
            var value = $(this).val();
            $(".v-ftpContent", parent).toggleClass("hidden", value != "FTP");
            $(".v-fileHelper", parent).toggleClass("hidden", value == "FTP");
            $(".v-deleteFileSection", parent).toggleClass("hidden", value != "FTP");
            $("#Schedule_PublishToFTP").val(value == "FTP" ? "True" : "False");
            $("#PublishToFTP").val(value == "FTP" ? "True" : "False");

            if (value != "FTP") {
                $("#Schedule_FTPConnection_DeleteFileOnDownload").attr("checked", false);
            }
        });


        $('input[type=radio][name="Schedule.FTPConnection.Security"]').on("change", function () {
            if ($('input[type=radio][name="Schedule.FTPConnection.Security"][value=SFTP]').is(':checked'))
                $("#sftpPrivateKey").show();
            else
                $("#sftpPrivateKey").hide();
        });

        $('input[type=radio][name="Schedule.FTPConnection.Security"]').trigger("change");

        scheduleEditor.context.on("blur", ".v-startDate", function () {
            scheduleEditor.refreshTimeSummary();
        });

        scheduleEditor.context.on("click", ".calendarIcon:not(.disabled)", function () {
            $("input.hasDatepicker", $(this).parent()).datepicker('show');
        });

        scheduleEditor.context.on("change", ".h-selectFrequence", function () {
            var value = $(this).val();

            if (value == "Weekly")
                $(".v-weeklyFrequence", scheduleEditor.context).show();
            else
                $(".v-weeklyFrequence", scheduleEditor.context).hide();
        });

        scheduleEditor.context.on("change", "#HasFrequence", function () {
            var value = $(this).val();
            var isWeekly = $(".h-selectFrequence", scheduleEditor.context).val() == "Weekly";
            $(".v-frequence", scheduleEditor.context).toggle(value != "false");
            $(".v-weeklyFrequence", scheduleEditor.context).toggle(value != "false" && isWeekly);
            $(".v-endDate", scheduleEditor.context).toggle(value != "false");
        });

        scheduleEditor.context.on("change", ".v-disableField", function () {
            var parent = $(this).closest("div");
            var isDisabled = $(this).is(':checked');
            $("input[type='text']", parent).prop("disabled", isDisabled);
            $("span.fa", parent).toggleClass("disabled", isDisabled);
        });

        scheduleEditor.context.on("keydown", ".v-validatePositiveInt", function (event) {
            a4.validateNumberKeyCode(event, false);
        });

        scheduleEditor.context.on("blur", ".v-validatePositiveInt", function (event) {
            if ($(this).val() == "0" || $.trim($(this).val()) == "") {
                $(this).val("1");
            }
        });

        scheduleEditor.context.on("change", ".h-selectFileNameSource", function () {
            scheduleEditor.showFileNameOption($(".h-selectFileName", scheduleEditor.context).val());
        });

        scheduleEditor.context.on("blur", ".h-selectFileName", function () {
            scheduleEditor.showFileNameOption($(this).val());
        });

        scheduleEditor.context.on("click", ".h-testConnection", function () {
            var panel = $(this).closest(".v-serverCredentials");
            var editor = $(this).closest(".v-scheduleEditor");

            a4.callServerMethod(a4.getAction("TestFTPConnection", "Analyze", "Survey"), { id: $("#Id", editor).val(), isImport: true, address: $("#Schedule_FTPConnection_Address", panel).val(), username: $("#Schedule_FTPConnection_Username", panel).val(), password: $("#Schedule_FTPConnection_Password", panel).val(), folder: $("#Schedule_FTPConnection_Folder", panel).val(), security: $("#Schedule_FTPConnection_Security:checked", panel).val(), openSSHPrivateKey: $("#Schedule_FTPConnection_OpenSSHPrivateKey", panel).val() },
            function (result) {
                if (result.Success)
                    a4.showSuccessMessage(result.Message, 2000);
                else
                    a4.showErrorMessage(result.Message);
            });
        });
    }
});